{

 #                #
##   TECH FONT    ##
## BY JEFF LEDGER ##
 #                #

Character mode TV Text driver, with font table   Rev 01

Doug Dingus  09/07

*********************************
* Character Mode TV Text Driver *   Adapted by Jeff Ledger
*********************************

I've adapted the routines from TV_Text to allow for drop-in compatibilty.
Even bin,hex,and dec have been moved and adapted.
I'm positive there are bugs, but it seems to work.

}

CON

  cols = 40
  rows = 24

  screensize = cols * rows
  lastrow = screensize - cols

  ' Set up the processor clock in the standard way for 80MHz on HYDRA
  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000

  
VAR

  long  col, row, color, flag
  
  word  screen[screensize]
  long  colors[8 * 2]

  byte          displayb[4096]   'allocate max display buffer in RAM  40x24 (longs)

  long          index            'just an index...

  long          params[4]
                '[0] screen memory
                '[1] font table
                '[2] pix_mode not yet implemented...
                '[3] colors, or 16 bit mode = $00
  
OBJ
  tv : "char_mode_08_TV"  'the TV display driver
  
PUB start |  c, o, d, p,ptr

   ' @fonttab use font.GetPointerToFontTable
    

    ptr := @fonttab
    if byte[ ptr+constant(" "*8) ] 
       byte[ ptr+constant(" "*8) ] := 0
       repeat constant(128 * 8)
         byte[ ptr++ ] := byte[ ptr ] >< 8


    params[0] := @displayb
{
    Simple display buffer, one character per byte.  40x24 = 960 bytes, unless 16 bit mode is on
}
    
    params[1] := @fonttab
    
    params[2] := $0000_0000    'Not implemented....  This is going to be pixel sizes and such...
                               'see driver for possible values
  
    
    params[3] := $000CeFa    'uncomment for two color mode test
   ' params[3] := $00   'running in 16 bit mode
   ' 1a = BLUE
   ' 2a = PURPLE
   ' 3a = PINK
   ' 4a = ORANGE
   ' 5a = RED


    tv.start(@params)    'start the tv cog & pass it the parameter block


PUB out(c) | i, k

'' Output a character
''
''     $00 = clear screen
''     $01 = home
''     $08 = backspace
''     $09 = tab (8 spaces per)
''     $0A = set X position (X follows)
''     $0B = set Y position (Y follows)
''     $0C = set color (color follows)
''     $0D = return
''  others = printable characters

  case flag
    $00: case c
           $00: wordfill(@displayb, $20, screensize)
                col := row := 0
           $01: col := row := 0
           $08: if col
                  col--
           $09: repeat
                  print(" ")
                while col & 7
           $0A..$0C: flag := c
                     return
           $0D: newline
           other: print(c)
    $0A: col := c // cols
    $0B: row := c // rows
    $0C: color := c & 7
  flag := 0


PRI print(c)

  displayb[row * cols + col] :=  + c
  if ++col == cols
    newline


PRI newline | i

  col := 0
  if ++row == rows
    row--
    wordmove(@displayb, @displayb[cols], lastrow)   'scroll lines
    wordfill(@displayb[lastrow], $20, cols)      'clear new line
    

PUB str(stringptr)

'' Print a zero-terminated string

  repeat strsize(stringptr)
    out(byte[stringptr++])


PUB dec(value) | i

'' Print a decimal number

  if value < 0
    -value
    out("-")

  i := 1_000_000_000

  repeat 10
    if value => i
      out(value / i + "0")
      value //= i
      result~~
    elseif result or i == 1
      out("0")
    i /= 10


PUB hex(value, digits)

'' Print a hexadecimal number

  value <<= (8 - digits) << 2
  repeat digits
    out(lookupz((value <-= 4) & $F : "0".."9", "A".."F"))


PUB bin(value, digits)

'' Print a binary number

  value <<= 32 - digits
  repeat digits
    out((value <-= 1) & 1 + "0")
    

    
DAT
              'font definition pixels are mirror image, due to the way waitvid works.
              'Tech Font by Jeff Ledger / UPPERS/lowers are duplicated.

              ' Re-arranged the characters for standard ASCII translation


fonttab
        byte byte %00000000     ' $00 USED FOR BLANK
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 

        byte byte %11111111     ' ...##...    $01
        byte byte %11111111     ' ...##..
        byte byte %11111111     ' ...##...
        byte byte %11111111     ' ...##...
        byte byte %11111111     ' ...##...
        byte byte %11111111     ' ...##...
        byte byte %11111111     ' ...##...
        byte byte %11111111     ' ...##...

        byte byte %00000000     ' $02 USED FOR CURSOR
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %01111111     ' 
        byte byte %01111111     ' 

        byte byte %00000000     ' ........    $03
        byte byte %00000000     ' ........
        byte byte %11111111     ' ########
        byte byte %11111111     ' ########
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........

        byte byte %00000000     ' ........    $04
        byte byte %11111111     ' ########
        byte byte %11111111     ' ########
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     '.........

        byte byte %00000000     ' ........    $05
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %11111111     ' ########
        byte byte %11111111     ' ########
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........

        byte byte %00110000     ' ..##....    $06
        byte byte %00110000     ' ..##....
        byte byte %00110000     ' ..##....
        byte byte %00110000     ' ..##....
        byte byte %00110000     ' ..##....
        byte byte %00110000     ' ..##....
        byte byte %00110000     ' ..##....
        byte byte %00110000     ' ..##....

        byte byte %00001100     ' ....##..    $07
        byte byte %00001100     ' ....##..
        byte byte %00001100     ' ....##..
        byte byte %00001100     ' ....##..
        byte byte %00001100     ' ....##..
        byte byte %00001100     ' ....##..
        byte byte %00001100     ' ....##..
        byte byte %00001100     ' ....##..

        byte byte %00000000     ' ........    $08
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %11100000     ' ###.....
        byte byte %11110000     ' ####....
        byte byte %00111000     ' ..###...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...

        byte byte %00011000     ' ...##...    $09
        byte byte %00011000     ' ...##...
        byte byte %00011100     ' ...###..
        byte byte %00001111     ' ....####
        byte byte %00000111     ' .....###
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........

        byte byte %00011000     ' ...##...    $0A
        byte byte %00011000     ' ...##...
        byte byte %00111000     ' ..###...
        byte byte %11110000     ' ####....
        byte byte %11100000     ' ###.....
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........

        byte byte %11000000     ' ##......    $0B
        byte byte %11000000     ' ##......
        byte byte %11000000     ' ##......
        byte byte %11000000     ' ##......
        byte byte %11000000     ' ##......
        byte byte %11000000     ' ##......
        byte byte %11111111     ' ########
        byte byte %11111111     ' ########

        byte byte %11000000     ' ##......    $0C
        byte byte %11100000     ' ###.....
        byte byte %01110000     ' .###....
        byte byte %00111000     ' ..###...
        byte byte %00011100     ' ...###..
        byte byte %00001110     ' ....###.
        byte byte %00000111     ' .....###
        byte byte %00000011     '.......##

        byte byte %00000011     ' ......##    $0D
        byte byte %00000111     ' .....###
        byte byte %00001110     ' ....###.
        byte byte %00011100     ' ...###..
        byte byte %00111000     ' ..###...
        byte byte %01110000     ' .###....
        byte byte %11100000     ' ###.....
        byte byte %11000000     ' ##......

        byte byte %11111111     ' ########    $0E
        byte byte %11111111     ' ########
        byte byte %11000000     ' ##......
        byte byte %11000000     ' ##......
        byte byte %11000000     ' ##......
        byte byte %11000000     ' ##......
        byte byte %11000000     ' ##......
        byte byte %11000000     ' ##......

        byte byte %11111111     ' ########    $0F
        byte byte %11111111     ' ########
        byte byte %00000011     ' ......##
        byte byte %00000011     ' ......##
        byte byte %00000011     ' ......##
        byte byte %00000011     ' ......##
        byte byte %00000011     ' ......##
        byte byte %00000011     ' ......##
        
        byte byte %00000000     ' ........    $10
        byte byte %00111100     ' ..####..
        byte byte %01111110     ' .######.
        byte byte %01111110     ' .######.
        byte byte %01111110     ' .######.
        byte byte %01111110     ' .######.
        byte byte %00111100     ' ..####..
        byte byte %00000000     ' ........

        byte byte %00000000     ' ........    $11
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %11111111     ' ########
        byte byte %11111111     ' ########
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........

        byte byte %00110110     ' ..##.##.    $12
        byte byte %01111111     ' .#######
        byte byte %01111111     ' .#######
        byte byte %01111111     ' .#######
        byte byte %00111110     ' ..#####.
        byte byte %00011100     ' ...###..
        byte byte %00001000     ' ....#...
        byte byte %00000000     ' ........

        byte byte %01100000     ' .##.....    $13
        byte byte %01100000     ' .##.....
        byte byte %01100000     ' .##.....
        byte byte %01100000     ' .##.....
        byte byte %01100000     ' .##.....
        byte byte %01100000     ' .##.....
        byte byte %01100000     ' .##.....
        byte byte %01100000     ' .##.....

        byte byte %00000000     ' ........    $14
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000111     ' .....###          
        byte byte %00001111     ' ....####
        byte byte %00011100     ' ...###..
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...


        byte byte %11000011     ' ##....##    $15
        byte byte %11100111     ' ###..###
        byte byte %01111110     ' .######.
        byte byte %00111100     ' ..####..
        byte byte %00111100     ' ..####..
        byte byte %01111110     ' .######.
        byte byte %11100111     ' ###..###
        byte byte %11000011     ' ##....##

        byte byte %00000000     ' ........    $16
        byte byte %00111100     ' ..####..
        byte byte %01111110     ' .##..##.
        byte byte %01100110     ' .##..##.
        byte byte %01100110     ' .##..##.
        byte byte %01111110     ' .##..##.
        byte byte %00111100     ' ..####..
        byte byte %00000000     ' ........

        byte byte %00011000     ' ...##...    $17
        byte byte %00011000     ' ...##...
        byte byte %01100110     ' .##..##.
        byte byte %01100110     ' .##..##..
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00111100     ' ..####..
        byte byte %00000000     ' ........

        byte byte %00000110     ' .....##.    $18
        byte byte %00000110     ' .....##.
        byte byte %00000110     ' .....##.
        byte byte %00000110     ' .....##.
        byte byte %00000110     ' .....##.
        byte byte %00000110     ' .....##.
        byte byte %00000110     ' .....##.
        byte byte %00000110     ' .....##.

        byte byte %00001000     ' ....#...    $19
        byte byte %00011100     ' ...###..
        byte byte %00111110     ' ..#####.
        byte byte %01111111     ' .#######
        byte byte %00111110     ' ..#####.
        byte byte %00011100     ' ...###..
        byte byte %00001000     ' ....#...
        byte byte %00000000     ' ........

        byte byte %00011000     ' ...##...    $1A
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %11111111     ' ########
        byte byte %11111111     ' ########
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...


        byte byte %11000000     ' ##.....    $1B
        byte byte %11000000     ' ##.....
        byte byte %00110000     ' ..##...
        byte byte %00110000     ' ..##...
        byte byte %11000000     ' ##.....
        byte byte %11000000     ' ##.....
        byte byte %00110000     ' ..##...
        byte byte %00110000     ' ..##...

        byte byte %00011000     ' ...##...    $1C
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...

        byte byte %00000000     ' ........    $1D
        byte byte %00000000     ' ........
        byte byte %00000011     ' ......##
        byte byte %00111110     ' ..#####.
        byte byte %01110110     ' .###.##.
        byte byte %00110110     ' ..##.##.
        byte byte %00110110     ' ..##.##.
        byte byte %00000000     ' ........

        byte byte %11111111     ' ########    $1E
        byte byte %01111111     ' .#######
        byte byte %00111111     ' ..######
        byte byte %00011111     ' ...#####
        byte byte %00001111     ' ....####
        byte byte %00000111     ' .....###
        byte byte %00000011     ' ......##
        byte byte %00000001     ' .......#

        byte byte %11110000     ' ####....    $1F
        byte byte %11110000     ' ####....
        byte byte %11110000     ' ####....
        byte byte %11110000     ' ####....
        byte byte %11110000     ' ####....
        byte byte %11110000     ' ####....
        byte byte %11110000     ' ####....
        byte byte %11110000     ' ####....


        byte byte %10000000     ' ........    $20  Space
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........

        byte byte %00000000     ' !
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00000000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 

        byte byte %01100110     ' "
        byte byte %01100110     ' 
        byte byte %01100110     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 

        byte byte %00000000     ' #
        byte byte %00100100     ' 
        byte byte %00100100     ' 
        byte byte %01111110     ' 
        byte byte %00110100     ' 
        byte byte %01111110     ' 
        byte byte %00110100     ' 
        byte byte %00110100     ' 

        byte byte %00000000     ' $
        byte byte %00001000     ' 
        byte byte %00111110     ' 
        byte byte %00101000     ' 
        byte byte %00111110     ' 
        byte byte %00001010     ' 
        byte byte %00111110     ' 
        byte byte %00011000     ' 

        byte byte %00000000     ' %
        byte byte %01110000     ' 
        byte byte %01010010     ' 
        byte byte %01110100     ' 
        byte byte %00001000     ' 
        byte byte %00011110     ' 
        byte byte %00101010     ' 
        byte byte %01001110     ' 

        byte byte %00000000     ' &
        byte byte %01111100     ' 
        byte byte %01000100     ' 
        byte byte %00111000     ' 
        byte byte %01100000     ' 
        byte byte %01101010     ' 
        byte byte %01100100     ' 
        byte byte %01111010     ' 

        byte byte %00000000     '  '
        byte byte %00011100     ' 
        byte byte %00011100     ' 
        byte byte %00000100     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 

        byte byte %00000000     ' (
        byte byte %00001100     '
        byte byte %00010000     '
        byte byte %00100000     '
        byte byte %00110000     '
        byte byte %00110000     '
        byte byte %00010000     '
        byte byte %00001100     '

        byte byte %00000000     '  )
        byte byte %00110000     '
        byte byte %00001000     '
        byte byte %00000100     '
        byte byte %00001100     '
        byte byte %00001100     '
        byte byte %00001000     '
        byte byte %00110000     '

        byte byte %00000000     ' *
        byte byte %00010000     ' 
        byte byte %01010100     ' 
        byte byte %00111000     ' 
        byte byte %01111100     ' 
        byte byte %00111000     ' 
        byte byte %01010100     ' 
        byte byte %00010000     ' 

        byte byte %00000000     ' +
        byte byte %00000000     ' 
        byte byte %00010000     ' 
        byte byte %00010000     ' 
        byte byte %00111110     ' 
        byte byte %00111110     ' 
        byte byte %00001100     ' 
        byte byte %00001100    ' .

        byte byte %00000000     '  ,
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00111000     ' 
        byte byte %00111000     ' 
        byte byte %00001000     ' 
        byte byte %00001000     ' 

        byte byte %00000000     ' ........    $2D  -
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %01111110     ' .######.
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........

        byte byte %00000000     ' .
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00111000     ' 
        byte byte %00111000     ' 

        byte byte %00000000     ' ........    $2F  /
        byte byte %00000110     ' .....##.
        byte byte %00001100     ' ....##..
        byte byte %00011000     ' ...##...
        byte byte %00110000     ' ..##....
        byte byte %01100000     ' .##.....
        byte byte %01000000     ' .#......
        byte byte %00000000     ' ........

        byte byte %00000000     ' 0
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000110     ' 
        byte byte %01101010     ' 
        byte byte %01110010     ' 
        byte byte %01100010     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' 1
        byte byte %00111000     ' 
        byte byte %00001000     ' 
        byte byte %00001000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00111100     ' 

        byte byte %00000000     ' 2
        byte byte %01111110    ' .
        byte byte %01000010     ' 
        byte byte %00000010     ' 
        byte byte %01111110     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' 3
        byte byte %00111110     ' 
        byte byte %00000010     ' 
        byte byte %00000010     ' 
        byte byte %00011110     ' 
        byte byte %00000110     ' 
        byte byte %00000110     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' 4
        byte byte %01000000     ' 
        byte byte %01000000     ' 
        byte byte %01000100     ' 
        byte byte %01000100     ' 
        byte byte %01111110     ' 
        byte byte %00001100     ' 
        byte byte %00001100     ' 

        byte byte %00000000     ' 5
        byte byte %00111110     ' 
        byte byte %00100000     ' 
        byte byte %00100000     ' 
        byte byte %00111110     ' 
        byte byte %00000110     ' 
        byte byte %01000110     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' 6
        byte byte %01111110     ' 
        byte byte %01000000     ' 
        byte byte %01000000     ' 
        byte byte %01111110     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' 7
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %00000100     ' 
        byte byte %00001000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 

        byte byte %00000000     ' 8
        byte byte %00111100     ' 
        byte byte %00100100     ' 
        byte byte %00100100     ' 
        byte byte %01111110     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' 9
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01111110     ' 
        byte byte %00000110     ' 
        byte byte %00000110     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' :
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00011000     ' 
        byte byte %00000000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00000000     ' 

        byte byte %00000000     ' ;
        byte byte %00000000     ' 
        byte byte %00000000     ' 
        byte byte %00111000     ' 
        byte byte %00000000     ' 
        byte byte %00111000     ' 
        byte byte %00111000     ' 
        byte byte %00001000     ' 

        byte byte %00001110     ' ....###.    $3C  <
        byte byte %00011000     ' ...##...
        byte byte %00110000     ' ..##....
        byte byte %01100000     ' .##.....
        byte byte %00110000     ' ..##....
        byte byte %00011000     ' ...##...
        byte byte %00001110     ' ....###.
        byte byte %00000000     ' ........

        byte byte %00000000     ' =
        byte byte %00000000     ' 
        byte byte %01111110     ' 
        byte byte %00000000     ' 
        byte byte %01111110     ' 
        byte byte %01111110     ' 
        byte byte %00000000     ' 
        byte byte %00000000     ' 

        byte byte %01110000     ' .###....    $3E  >
        byte byte %00011000     ' ...##...
        byte byte %00001100     ' ....##..
        byte byte %00000110     ' .....##.
        byte byte %00001100     ' ....##..
        byte byte %00011000     ' ...##...
        byte byte %01110000     ' .###....
        byte byte %00000000     ' ........

        byte byte %00000000     ' ?
        byte byte %01111110     '
        byte byte %01000010     '
        byte byte %00000010     '
        byte byte %00111110     '
        byte byte %00110000     '
        byte byte %00000000     '
        byte byte %00110000     '

        byte byte %00000000     ' @
        byte byte %01111110     ' 
        byte byte %01000110     ' 
        byte byte %01001110     ' 
        byte byte %01101110     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' A
        byte byte %00111100     ' 
        byte byte %00100100     ' 
        byte byte %01111110     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 

        byte byte %00000000     ' B
        byte byte %01111100     ' 
        byte byte %00100100     ' 
        byte byte %00111100     ' 
        byte byte %00110010     ' 
        byte byte %00110010     ' 
        byte byte %00110010     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' C
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01100010     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' D
        byte byte %01111110
        byte byte %01000010
        byte byte %01000010
        byte byte %01100010
        byte byte %01100010
        byte byte %01100010
        byte byte %01111110

        byte byte %00000000     ' E
        byte byte %01111110     ' 
        byte byte %01000000     ' 
        byte byte %01000000     ' 
        byte byte %01111000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' F
        byte byte %01111110     ' 
        byte byte %01000000     ' 
        byte byte %01000000     ' 
        byte byte %01111000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 

        byte byte %00000000     ' G
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000000     '
        byte byte %01101110     '
        byte byte %01100010     '
        byte byte %01100010     '
        byte byte %01111110     '.

        byte byte %00000000     ' H
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01111110     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 

        byte byte %00000000     ' I
        byte byte %00010000     ' 
        byte byte %00010000     ' 
        byte byte %00010000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 

        byte byte %00000000     ' J
        byte byte %00000010     ' 
        byte byte %00000010     ' 
        byte byte %00000010     ' 
        byte byte %00000110     ' 
        byte byte %00000110     ' 
        byte byte %01000110     ' 
        byte byte %00111110     ' 

        byte byte %00000000     ' K
        byte byte %01000010     ' 
        byte byte %01000100     ' 
        byte byte %01001000     ' 
        byte byte %01111110     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 

        byte byte %00000000     ' L
        byte byte %01000000     ' 
        byte byte %01000000     ' 
        byte byte %01000000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' M
        byte byte %01110110     ' 
        byte byte %01011010     ' 
        byte byte %01000010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 

        byte byte %00000000     ' N
        byte byte %01110010     ' 
        byte byte %01001010     ' 
        byte byte %01001010     ' 
        byte byte %01101010     ' 
        byte byte %01101010     ' 
        byte byte %01101010     ' 
        byte byte %01100110     ' 

        byte byte %00000000     ' O
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' P
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01111110     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 

        byte byte %00000000     ' Q
        byte byte %01111110     '
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %01100010     '
        byte byte %01101010     '
        byte byte %01100100     '
        byte byte %01111010     '

        byte byte %00000000     ' R
        byte byte %01111110     '
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %01111110     '
        byte byte %01100100     '
        byte byte %01100010     '
        byte byte %01100010     '

        byte byte %00000000     ' S
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000000     ' 
        byte byte %01111110     ' 
        byte byte %00000110     ' 
        byte byte %00000110     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' T
        byte byte %01111110     ' 
        byte byte %00010000     ' 
        byte byte %00010000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 

        byte byte %00000000     ' U
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %01100010     '
        byte byte %01100010     '
        byte byte %01100010     '
        byte byte %01111110     '

        byte byte %00000000     ' V
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %00100100     '
        byte byte %00100100     '
        byte byte %00011000     '
        byte byte %00011000     '

        byte byte %00000000     ' W
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01000010     ' 
        byte byte %01011010     ' 
        byte byte %01100110     ' 

        byte byte %00000000     ' X
        byte byte %01000010     ' 
        byte byte %00100100     ' 
        byte byte %00011000     ' 
        byte byte %01111100     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 

        byte byte %00000000     ' Y
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %00111100     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 

        byte byte %00000000     ' Z
        byte byte %01111100     ' 
        byte byte %00000010     ' 
        byte byte %00011100     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' [
        byte byte %00111100     ' 
        byte byte %00100000     ' 
        byte byte %00100000     ' 
        byte byte %00110000     ' 
        byte byte %00110000     ' 
        byte byte %00110000     ' 
        byte byte %00111100     ' 

        byte byte %00000000     ' ........    $5C  \
        byte byte %01000000     ' .#......
        byte byte %01100000     ' .##.....
        byte byte %00110000     ' ..##....
        byte byte %00011000     ' ...##...
        byte byte %00001100     ' ....##..
        byte byte %00000110     ' .....##.
        byte byte %00000000     ' ........

        byte byte %00000000     ' ]
        byte byte %00111100     ' 
        byte byte %00000100     ' 
        byte byte %00000100     ' 
        byte byte %00001100     ' 
        byte byte %00001100     ' 
        byte byte %00001100     ' 
        byte byte %00111100     ' 

        byte byte %00000000     ' ........    $5E  ^
        byte byte %00001000     ' ....#...
        byte byte %00011100     ' ...###..
        byte byte %00110110     ' ..##.##.
        byte byte %01100011     ' .##...##
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........

        byte byte %00000000     ' ........    $5F  _
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %01111110     ' .######.
        byte byte %00000000     ' ........

        byte byte %00011000     ' ...##...    $60  `
        byte byte %00000000     ' ........
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00000000     ' ........

        byte byte %00000000     ' A
        byte byte %00111100     ' 
        byte byte %00100100     ' 
        byte byte %01111110     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 

        byte byte %00000000     ' B
        byte byte %01111100     ' 
        byte byte %00100100     ' 
        byte byte %00111100     ' 
        byte byte %00110010     ' 
        byte byte %00110010     ' 
        byte byte %00110010     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' C
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01100010     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' D
        byte byte %01111110
        byte byte %01000010
        byte byte %01000010
        byte byte %01100010
        byte byte %01100010
        byte byte %01100010
        byte byte %01111110

        byte byte %00000000     ' E
        byte byte %01111110     ' 
        byte byte %01000000     ' 
        byte byte %01000000     ' 
        byte byte %01111000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' F
        byte byte %01111110     ' 
        byte byte %01000000     ' 
        byte byte %01000000     ' 
        byte byte %01111000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 

        byte byte %00000000     ' G
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000000     '
        byte byte %01101110     '
        byte byte %01100010     '
        byte byte %01100010     '
        byte byte %01111110     '.

        byte byte %00000000     ' H
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01111110     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 

        byte byte %00000000     ' I
        byte byte %00010000     ' 
        byte byte %00010000     ' 
        byte byte %00010000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 

        byte byte %00000000     ' J
        byte byte %00000010     ' 
        byte byte %00000010     ' 
        byte byte %00000010     ' 
        byte byte %00000110     ' 
        byte byte %00000110     ' 
        byte byte %01000110     ' 
        byte byte %00111110     ' 

        byte byte %00000000     ' K
        byte byte %01000010     ' 
        byte byte %01000100     ' 
        byte byte %01001000     ' 
        byte byte %01111110     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 

        byte byte %00000000     ' L
        byte byte %01000000     ' 
        byte byte %01000000     ' 
        byte byte %01000000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' M
        byte byte %01110110     ' 
        byte byte %01011010     ' 
        byte byte %01000010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 

        byte byte %00000000     ' N
        byte byte %01110010     ' 
        byte byte %01001010     ' 
        byte byte %01001010     ' 
        byte byte %01101010     ' 
        byte byte %01101010     ' 
        byte byte %01101010     ' 
        byte byte %01100110     ' 

        byte byte %00000000     ' O
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' P
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01111110     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 

        byte byte %00000000     ' Q
        byte byte %01111110     '
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %01100010     '
        byte byte %01101010     '
        byte byte %01100100     '
        byte byte %01111010     '

        byte byte %00000000     ' R
        byte byte %01111110     '
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %01111110     '
        byte byte %01100100     '
        byte byte %01100010     '
        byte byte %01100010     '

        byte byte %00000000     ' S
        byte byte %01111110     ' 
        byte byte %01000010     ' 
        byte byte %01000000     ' 
        byte byte %01111110     ' 
        byte byte %00000110     ' 
        byte byte %00000110     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' T
        byte byte %01111110     ' 
        byte byte %00010000     ' 
        byte byte %00010000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 

        byte byte %00000000     ' U
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %01100010     '
        byte byte %01100010     '
        byte byte %01100010     '
        byte byte %01111110     '

        byte byte %00000000     ' V
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %01000010     '
        byte byte %00100100     '
        byte byte %00100100     '
        byte byte %00011000     '
        byte byte %00011000     '

        byte byte %00000000     ' W
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01000010     ' 
        byte byte %01011010     ' 
        byte byte %01100110     ' 

        byte byte %00000000     ' X
        byte byte %01000010     ' 
        byte byte %00100100     ' 
        byte byte %00011000     ' 
        byte byte %01111100     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 
        byte byte %01100010     ' 

        byte byte %00000000     ' Y
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %01000010     ' 
        byte byte %00111100     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 
        byte byte %00011000     ' 

        byte byte %00000000     ' Z
        byte byte %01111100     ' 
        byte byte %00000010     ' 
        byte byte %00011100     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01100000     ' 
        byte byte %01111110     ' 

        byte byte %00000000     ' ........    $7B  {
        byte byte %00011100     ' ...###..
        byte byte %00011000     ' ...##...
        byte byte %01111000     ' .###....
        byte byte %01111000     ' .###....
        byte byte %00011000     ' ...##...
        byte byte %00011100     ' ...###..
        byte byte %00000000     ' ........

        byte byte %00011000     ' ...##...    $7C  |
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...
        byte byte %00011000     ' ...##...

        byte byte %00000000     ' ........    $7D  }
        byte byte %00111000     ' ..###...
        byte byte %00011000     ' ...##...
        byte byte %00011110     ' ....###.
        byte byte %00011110     ' ....###.
        byte byte %00011000     ' ...##...
        byte byte %00111000     ' ..###...
        byte byte %00000000     ' ........

        byte byte %00000000     ' ........    $7E  ~
        byte byte %00110011     ' ..##..##
        byte byte %01111110     ' .######.
        byte byte %11001100     ' ##..##..
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........

        byte byte %00000000     ' ........    $7F
        byte byte %00111000     ' ..###...
        byte byte %01000100     ' .#...#..
        byte byte %01000100     ' .#...#..
        byte byte %00111000     ' ..###...
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........
        byte byte %00000000     ' ........

          